﻿IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_UpdateOrCreateResponses]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_UpdateOrCreateResponses]
GO

CREATE PROCEDURE [dbo].[sp_UpdateOrCreateResponses]
	@Responses AS [dbo].[ResponseList] READONLY,
	@ProjectId INT, 
	@CollectMode INT,
    @ModifiedBy INT,
	@Modified DATETIME,
	@Source NVARCHAR(MAX)
AS
BEGIN
	SET NOCOUNT ON;

	IF @Modified IS NULL
	BEGIN
		SET @Modified = GETUTCDATE();
	END

	UPDATE r
	SET r.[RpsContent] = l.[RpsContent],
		r.[RpsOpened] = l.[RpsOpened],
		r.[CallId] = l.[CallId],
		r.[ProjectId] = @ProjectId,
		r.[CollectMode] = CASE WHEN @CollectMode < 0 THEN r.[CollectMode] ELSE @CollectMode END,
		r.[ModifiedBy] = @ModifiedBy,
		r.[Modified] = @Modified,
		r.[Source] = @Source
	FROM @Responses l
	INNER JOIN [dbo].[Response] r
		ON l.[RpsRespondent] = r.[RpsRespondent]
		AND l.[RpsQuestion] = r.[RpsQuestion]
		AND l.[RpsMatrix] = r.[RpsMatrix]
		AND l.[RpsMention] = r.[RpsMention]
		AND l.[RpsType] = r.[RpsType];

	INSERT INTO [dbo].[Response] (
		[RpsRespondent],
		[RpsQuestion],
		[RpsMatrix],
		[RpsMention],
		[RpsType],
		[RpsContent],
		[RpsOpened],
		[CallId],
		[ProjectId],
		[CollectMode],
		[ModifiedBy],
		[Modified],
		[Source])
	SELECT
		l.[RpsRespondent],
		l.[RpsQuestion],
		l.[RpsMatrix],
		l.[RpsMention],
		l.[RpsType],
		l.[RpsContent],
		l.[RpsOpened],
		l.[CallId],
		@ProjectId,
		@CollectMode,
		@ModifiedBy,
		@Modified,
		@Source
	FROM @Responses l
	LEFT JOIN [dbo].[Response] r
		ON l.[RpsRespondent] = r.[RpsRespondent]
		AND l.[RpsQuestion] = r.[RpsQuestion]
		AND l.[RpsMatrix] = r.[RpsMatrix]
		AND l.[RpsMention] = r.[RpsMention]
		AND l.[RpsType] = r.[RpsType]
	WHERE r.[RpsRespondent] IS NULL;
END
GO
